import matplotlib.pyplot as plt
import seaborn as sns
import pandas as pd
import pickle
from decision_company import read_csv_file, count_unique_values, transform, generate_summary_stat, concatenate_objects, create_dataframe, generate_summary_stat, create_subplots, create_histogram_subplot, set_plot_split_title, make_xlabel, save_plot, create_scatter_plot, make_ylabel, create_bar_chart, show_plots

atp_tennis = read_csv_file('atp_tennis.csv')

# Count the number of wins for each player:
player_wins = count_unique_values(atp_tennis['Winner'])

# Count the total number of matches played by each player:
player_matches = count_unique_values(atp_tennis['Player_1']) + count_unique_values(atp_tennis['Player_2'])


# Calculate win/loss ratio for each player:
win_loss_ratios = player_wins / (player_matches - player_wins)

# Add win/loss ratios to the dataset:
atp_tennis['Win_Loss_Ratio_1'] = transform(atp_tennis['Player_1'], win_loss_ratios)
atp_tennis['Win_Loss_Ratio_2'] = transform(atp_tennis['Player_2'], win_loss_ratios)


# Descriptive Statistics Table:
desc_stats = generate_summary_stat(atp_tennis[['Rank_1', 'Rank_2', 'Win_Loss_Ratio_1', 'Win_Loss_Ratio_2']])

# Combine Rank_1, Rank_2, Win_Loss_Ratio_1, and Win_Loss_Ratio_2 into single columns:
combined_ranks = concatenate_objects(atp_tennis['Rank_1'], atp_tennis['Rank_2'])
combined_win_loss_ratios = concatenate_objects(atp_tennis['Win_Loss_Ratio_1'], atp_tennis['Win_Loss_Ratio_2'])

# Create a DataFrame with combined ranks and win/loss ratios:
combined_data = create_dataframe({'Rank': combined_ranks, 'Win_Loss_Ratio': combined_win_loss_ratios})


# Descriptive Statistics Table:
desc_stats = generate_summary_stat(combined_data)


# Histogram for Player Rankings Distribution:
fig1, ax1 = create_subplots()
create_histogram_subplot(ax1, combined_ranks, bins=50, alpha=0.5)
set_plot_split_title(ax1, 'Player Rankings Distribution')
make_xlabel(ax1, 'Ranking')
save_plot('./ref_result/hist_chart.png')
show_plots()


# Scatter Plot for Player Rankings vs Win/Loss Ratios:
fig2, ax2 = create_subplots()
create_scatter_plot(ax2, combined_data['Rank'], combined_data['Win_Loss_Ratio'], alpha=0.5)
set_plot_split_title(ax2, 'Player Rankings vs Win/Loss Ratios')
make_xlabel(ax2, 'Ranking')
make_ylabel(ax2, 'Win/Loss Ratio')
save_plot('./ref_result/scatter_chart.png')
show_plots()


# Bar Chart for Surface Types:
fig3, ax3 = create_subplots()
surface_counts = count_unique_values(atp_tennis['Surface'])
create_bar_chart(ax3, surface_counts)
set_plot_split_title(ax3, 'Matches by Surface Type')
make_xlabel(ax3, 'Surface')
make_ylabel(ax3, 'Number of Matches')
save_plot('./ref_result/bar_chart.png')
show_plots()

print(desc_stats)
pickle.dump(desc_stats,open("./ref_result/desc_stats.pkl","wb"))